---
title: Access your Worker's environment variables from process.env · Changelog
description: With Node.js compatibility on, process.env is automatically
  populated with environment variables and secrets
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-03-11-process-env-support/
  md: https://developers.cloudflare.com/changelog/2025-03-11-process-env-support/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Access your Worker's environment variables from process.env

Mar 11, 2025

[Workers](https://developers.cloudflare.com/workers/)

You can now access [environment variables](https://developers.cloudflare.com/workers/configuration/environment-variables/) and [secrets](https://developers.cloudflare.com/workers/configuration/secrets/) on [`process.env`](https://developers.cloudflare.com/workers/runtime-apis/nodejs/process/#processenv) when using the [`nodejs_compat` compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#nodejs-compatibility-flag).

```js
const apiClient = ApiClient.new({ apiKey: process.env.API_KEY });
const LOG_LEVEL = process.env.LOG_LEVEL || "info";
```

In Node.js, environment variables are exposed via the global `process.env` object. Some libraries assume that this object will be populated, and many developers may be used to accessing variables in this way.

Previously, the `process.env` object was always empty unless written to in Worker code. This could cause unexpected errors or friction when developing Workers using code previously written for Node.js.

Now, [environment variables](https://developers.cloudflare.com/workers/configuration/environment-variables/), [secrets](https://developers.cloudflare.com/workers/configuration/secrets/), and [version metadata](https://developers.cloudflare.com/workers/runtime-apis/bindings/version-metadata/) can all be accessed on `process.env`.

To opt-in to the new `process.env` behaviour now, add the [`nodejs_compat_populate_process_env`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#enable-auto-populating-processenv) compatibility flag to your `wrangler.json` configuration:

* wrangler.jsonc

  ```jsonc
  {
    // Rest of your configuration
    // Add "nodejs_compat_populate_process_env" to your compatibility_flags array
    "compatibility_flags": ["nodejs_compat", "nodejs_compat_populate_process_env"],
    // Rest of your configuration
  ```

* wrangler.toml

  ```toml
  compatibility_flags = [ "nodejs_compat", "nodejs_compat_populate_process_env" ]
  ```

After April 1, 2025, populating `process.env` will become the default behavior when both `nodejs_compat` is enabled and your Worker's `compatibility_date` is after "2025-04-01".
