---
title: Choosing between Wrangler & Vite · Cloudflare Workers docs
description: Choosing between Wrangler and Vite for local development
lastUpdated: 2025-09-18T22:01:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/development-testing/wrangler-vs-vite/
  md: https://developers.cloudflare.com/workers/development-testing/wrangler-vs-vite/index.md
---

# When to use Wrangler vs Vite

Deciding between Wrangler and the Cloudflare Vite plugin depends on your project's focus and development workflow. Here are some quick guidelines to help you choose:

## When to use Wrangler

* **Backend & Workers-focused:** If you're primarily building APIs, serverless functions, or background tasks, use Wrangler.

* **Remote development:** If your project needs the ability to run your worker remotely on Cloudflare's network, use Wrangler's `--remote` flag.

* **Simple frontends:** If you have minimal frontend requirements and don’t need hot reloading or advanced bundling, Wrangler may be sufficient.

## When to use the Cloudflare Vite Plugin

Use the [Vite plugin](https://developers.cloudflare.com/workers/vite-plugin/) for:

* **Frontend-centric development:** If you already use Vite with modern frontend frameworks like React, Vue, Svelte, or Solid, the Vite plugin integrates into your development workflow.

* **React Router v7:** If you are using [React Router v7](https://reactrouter.com/) (the successor to Remix), it is officially supported by the Vite plugin as a full-stack SSR framework.

* **Rapid iteration (HMR):** If you need near-instant updates in the browser, the Vite plugin provides [Hot Module Replacement (HMR)](https://vite.dev/guide/features.html#hot-module-replacement) during local development.

* **Advanced optimizations:** If you require more advanced optimizations (code splitting, efficient bundling, CSS handling, build time transformations, etc.), Vite is a strong fit.

* **Greater flexibility:** Due to Vite's advanced configuration options and large ecosystem of plugins, there is more flexibility to customize your development experience and build output.
